/*
 * Created on Aug 1, 2003
 */
package Interface;
import Data.*;
import DatabaseCommunication.*;
import Validators.*;
import java.awt.*;
import java.sql.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.TitledBorder;
/**
 * @author student
 * This class is being used for implementing Announcement functionality
 * 
 */
public class TabAnnouncement
	extends JPanel
	implements ActionListener, ListSelectionListener {
	final static JLabel timeLabel = new JLabel("Time :");
	final static JLabel subjectLabel = new JLabel("Subject :");
	final static JLabel postSubjectLabel = new JLabel("Subject :");
	final static JLabel announcementLabel = new JLabel("Announcement :");
	final static JLabel fromLabel = new JLabel("From :");
	final static JLabel label = new JLabel("Time     Subject");
	final static JLabel message = new JLabel();
	static JList listA;
	static DefaultListModel listModel;
	static JTextField from = new JTextField();
	static JTextField timeBoxA = new JTextField();
	static JTextArea announcementArea = new JTextArea(5, 5);
	static JTextArea postArea = new JTextArea();
	static JTextArea subjectArea = new JTextArea(2, 5);
	static JTextArea postSubject = new JTextArea(2, 5);
	static JButton readButton = new JButton("READ");
	static JButton postButton = new JButton("POST");
	static AnnouncementData[] announcementArray;
	static AnnouncementData announcement = new AnnouncementData();
	private static UserData user = new UserData();
	/**
	 * This is the constructor for TabAnnouncement.java
	 */
	public TabAnnouncement() {
		super();
	}
	/**
	 * This is the constructor for TabAnnouncement.java for a particular user
	 */
	public TabAnnouncement(UserData user) {
		TabAnnouncement.user = user;
	}
	public JPanel createTabAnnouncement() {
		JPanel aPanel = new JPanel();
		aPanel.setLayout(new BoxLayout(aPanel, BoxLayout.X_AXIS));
		JPanel titledLeftBorders = new JPanel();
		TitledBorder readTitled =
			BorderFactory.createTitledBorder("Read Announcements");
		JPanel read = new JPanel();
		read.setBorder(readTitled);
		read.setLayout(new BoxLayout(read, BoxLayout.Y_AXIS));
		//Update the List
		listModel = new DefaultListModel();
		fillAnnouncements();
		listA = new JList(listModel);
		listA.setFont(new Font("Times New Roman", Font.BOLD, 12));
		listA.setModel(listModel);
		listA.addListSelectionListener(this);
		listA.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		listA.setLayoutOrientation(JList.VERTICAL);
		listA.setVisibleRowCount(-1);
		JScrollPane listScroller = new JScrollPane(listA);
		listScroller.setPreferredSize(new Dimension(250, 50));
		read.add(listScroller);
		JPanel listPane = new JPanel();
		listPane.setLayout(new BoxLayout(listPane, BoxLayout.PAGE_AXIS));
		label.setLabelFor(listA);
		listPane.add(label);
		listPane.add(Box.createRigidArea(new Dimension(0, 5)));
		listPane.add(listScroller);
		listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		read.add(listPane);
		read.add(readButton);
		readButton.setActionCommand("read");
		readButton.addActionListener(this);
		read.add(timeLabel);
		timeLabel.setLabelFor(timeBoxA);
		timeBoxA.setEditable(false);
		read.add(timeBoxA);
		read.add(subjectLabel);
		subjectLabel.setLabelFor(subjectArea);
		read.add(subjectArea);
		subjectArea.setEditable(false);
		subjectArea.setLineWrap(true);
		JScrollPane scrollSubject = new JScrollPane(subjectArea);
		scrollSubject.setPreferredSize(new Dimension(10, 25));
		scrollSubject.setHorizontalScrollBarPolicy(
		JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		read.add(scrollSubject);
		read.add(announcementLabel);
		announcementLabel.setLabelFor(announcementArea);
		read.add(announcementArea);
		announcementArea.setEditable(false);
		subjectArea.setLineWrap(true);
		JScrollPane scrollAnnouncement = new JScrollPane(announcementArea);
		scrollAnnouncement.setPreferredSize(new Dimension(10, 50));
		scrollAnnouncement.setHorizontalScrollBarPolicy(
		JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		read.add(scrollAnnouncement);
		read.add(fromLabel);
		fromLabel.setLabelFor(from);
		read.add(from);
		from.setEditable(false);
		titledLeftBorders.add(read);
		aPanel.add(titledLeftBorders, BorderLayout.WEST);
		JPanel rightTitledBorders = new JPanel();
		TitledBorder rightTitled = BorderFactory.createTitledBorder("Post");
		JPanel post = new JPanel();
		post.setBorder(rightTitled);
		post.setLayout(new BoxLayout(post, BoxLayout.Y_AXIS));
		JLabel postLabel = new JLabel("Post Announcements");
		post.add(postSubjectLabel);
		post.add(postSubject);
		postSubject.setEditable(true);
		postSubject.setLineWrap(true);
		JScrollPane scrollPostSubject = new JScrollPane(postSubject);
		scrollPostSubject.setPreferredSize(new Dimension(10, 25));
		scrollPostSubject.setHorizontalScrollBarPolicy(
		JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		post.add(scrollPostSubject);
		postArea.setEditable(true);
		postArea.setLineWrap(true);
		JScrollPane scrollPane = new JScrollPane(postArea);
		scrollPane.setPreferredSize(new Dimension(50, 100));
		scrollPane.setHorizontalScrollBarPolicy(
		JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		post.add(scrollPane);
		postButton.setActionCommand("post");
		postButton.addActionListener(this);
		post.add(postButton);
		rightTitledBorders.add(post);
		message.setHorizontalAlignment(SwingConstants.CENTER);
		message.setPreferredSize(new Dimension(200, 50));
		post.add(message);
		aPanel.add(rightTitledBorders, BorderLayout.EAST);
		return aPanel;
	}
	public void valueChanged(ListSelectionEvent e) {
	}
	/**
	 * This method is being used to fill announcement List
	 */
	public static void fillAnnouncements() {
		AnnouncementManager aManager = new AnnouncementManager();
		announcementArray = new AnnouncementData[10];
		try {
			announcementArray = aManager.selectAllAnnouncements();
			for (int i = 0; i < announcementArray.length; i++) {
				if (announcementArray[i] != null) {
					listModel.addElement(
						announcementArray[i].getTime().getHours()
							+ ":"
							+ announcementArray[i].getTime().getMinutes()
							+ "   "
							+ announcementArray[i].getSubject());
					listA.setModel(listModel);
				}
			}
		} catch (Exception exp) {
		}
	}
	/**
	 * This method is being used refresh the announcement List
	 *  void
	 */
	public void refresh() {
		listModel = new DefaultListModel();
		fillAnnouncements();
	}
	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		if (command == "read") {
			display(listA.getSelectedIndex());
		} else if (command == "post") {
			UserManager uManager = new UserManager();
			String name = "";
			try {
				name = uManager.getName(user.getLoginId());
			} catch (Exception exp) {
			}
			//set message properties		
			announcement.setFrom(name);
			announcement.setBody(postArea.getText());
			announcement.setSubject(postSubject.getText());
			//get the current time	
			long currentTime = System.currentTimeMillis();
			announcement.setTime(new Timestamp(currentTime));
			System.out.println("Announcement time " + announcement.getTime());
			updateDatabase();
		} else
			message.setText("");
	}
	/**
	 * This method is being used to update announcement in the databse
	 *  void
	 */
	public static void updateDatabase() {
		//Checking for valid time field before updating the database
		AnnouncementValidator aValidator = new AnnouncementValidator();
		boolean validAnnouncement = aValidator.validate(announcement);
		if (!validAnnouncement) {
			message.setText(aValidator.getMessage());
			return;
		}
		AnnouncementManager aManager = new AnnouncementManager();
		try {
			aManager.insertAnnouncementData(announcement);
			message.setText("Announcement has been posted");
		} catch (Exception exp) {
			//message.setText("Error while posting announcement "+exp.toString());
			message.setText(
				"Announcement could not be posted .Please try again later.");
		}
	}
	/**
	 * This method is being used display announcement
	 * @param i void
	 */
	private void display(int i) {
		//Returns a new string that is a substring of this string. 
		//The substring begins at the specified beginIndex and extends to the character at index endIndex - 1. 
		String time = announcementArray[i].getTime().toString();
		String subject = announcementArray[i].getSubject();
		timeBoxA.setText(time);
		subjectArea.setText(subject);
		announcementArea.setText(announcementArray[i].getBody());
		from.setText(announcementArray[i].getFrom());
	}
	/**
	 * This method is being used to add days
	 * @param startDate
	 * @param numberOfDays
	 * @return long
	 */
	public static long addDays(java.util.Date startDate, int numberOfDays) {
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(startDate);
		cal.add(Calendar.DATE, numberOfDays);
		return cal.getTimeInMillis();
	}
}
